/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.upgrade_aquatic.common.entities.jellyfish;

import com.minecraftabnormals.abnormals_core.common.entity.ai.PredicateAttackGoal;
import com.minecraftabnormals.abnormals_core.core.endimator.Endimation;
import com.minecraftabnormals.upgrade_aquatic.common.blocks.JellyTorchBlock;
import com.minecraftabnormals.upgrade_aquatic.common.entities.jellyfish.AbstractJellyfishEntity;
import com.minecraftabnormals.upgrade_aquatic.common.entities.jellyfish.ColoredSizableJellyfishEntity;
import com.minecraftabnormals.upgrade_aquatic.common.entities.jellyfish.ai.BoxJellyfishHuntGoal;
import com.minecraftabnormals.upgrade_aquatic.common.entities.jellyfish.ai.JellyfishBoostGoal;
import com.minecraftabnormals.upgrade_aquatic.common.entities.jellyfish.ai.JellyfishSwimIntoDirectionGoal;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class BoxJellyfishEntity
extends ColoredSizableJellyfishEntity {
    private AbstractJellyfishEntity.RotationController rotationController = new AbstractJellyfishEntity.RotationController(this);
    private int huntingCooldown;

    public BoxJellyfishEntity(EntityType<? extends BoxJellyfishEntity> type, World world) {
        super(type, world);
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233823_f_, 5.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new BoxJellyfishHuntGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new JellyfishSwimIntoDirectionGoal(this, SWIM_ANIMATION));
        this.field_70714_bg.func_75776_a(3, (Goal)new JellyfishBoostGoal(this, BOOST_ANIMATION));
        this.field_70715_bh.func_75776_a(1, (Goal)new PredicateAttackGoal((MobEntity)this, AbstractFishEntity.class, 150, true, true, null, owner -> !((BoxJellyfishEntity)((Object)owner)).hasCooldown() && !((BoxJellyfishEntity)((Object)owner)).hasHuntingCooldown()));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.hasHuntingCooldown()) {
            --this.huntingCooldown;
        }
        if (this.isEndimationPlaying(BOOST_ANIMATION) && this.func_70090_H()) {
            this.func_213317_d(this.func_213322_ci().func_186678_a((double)1.15f));
        }
    }

    public void onEndimationStart(Endimation endimation) {
        if (endimation == SWIM_ANIMATION) {
            this.getRotationController().addVelocityForLookDirection(0.6f, this.getSize());
        } else if (endimation == BOOST_ANIMATION) {
            this.getRotationController().addVelocityForLookDirection(0.25f, this.getSize());
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("HuntingCooldown", this.huntingCooldown);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.huntingCooldown = compound.func_74762_e("HuntingCooldown");
    }

    public EntitySize func_213305_a(Pose pose) {
        return super.func_213305_a(pose).func_220313_a(this.getSize());
    }

    public void setHuntingCooldown() {
        this.huntingCooldown = this.func_70681_au().nextInt(1600) + 1200;
    }

    public boolean hasHuntingCooldown() {
        return this.huntingCooldown > 0;
    }

    protected float func_213348_b(Pose poseIn, EntitySize size) {
        return size.field_220316_b * 0.5f;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (super.func_70097_a(source, amount)) {
            Entity entity = source.func_76346_g();
            if (!(!(entity instanceof LivingEntity) || this.func_70638_az() != null || entity.func_175149_v() || entity instanceof PlayerEntity && ((PlayerEntity)entity).func_184812_l_())) {
                this.func_70624_b((LivingEntity)entity);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getBucketName() {
        switch (this.getColor()) {
            default: {
                return "box";
            }
            case 1: {
                return "red_box";
            }
            case 2: 
        }
        return "white_box";
    }

    @Override
    public JellyTorchBlock.JellyTorchType getJellyTorchType() {
        switch (this.getColor()) {
            default: {
                return JellyTorchBlock.JellyTorchType.BLUE;
            }
            case 1: {
                return JellyTorchBlock.JellyTorchType.RED;
            }
            case 2: 
        }
        return JellyTorchBlock.JellyTorchType.WHITE;
    }

    @Override
    public float getCooldownChance() {
        return this.getSize() >= 1.0f ? 0.05f : (this.getSize() < 0.5f ? 0.1f : 0.15f);
    }

    @Override
    public boolean stingEntity(LivingEntity livingEntity) {
        if (super.stingEntity(livingEntity)) {
            livingEntity.func_195064_c(new EffectInstance(Effects.field_76436_u, 600, 1));
            if (this.func_70638_az() == null) {
                this.func_70624_b(livingEntity);
            }
            return true;
        }
        return false;
    }

    @Override
    protected String getBucketEntityId() {
        return "box_jellyfish";
    }

    @Override
    protected float getDefaultSize() {
        return 1.0f;
    }

    @Override
    protected float getHealthSizeMultiplier() {
        return 8.0f;
    }

    @Override
    public AbstractJellyfishEntity.RotationController getRotationController() {
        return this.rotationController;
    }

    public int func_70641_bl() {
        return 3;
    }
}

